/***************************************************************************/
/*                                                                         */
/*  ftobjsext.c                                                            */
/*                                                                         */
/*   MTI extension to the FreeType base classes                            */
/*                                                                         */
/*  Copyright (C) 2012 Monotype Imaging Inc. All rights reserved.          */
/*                                                                         */
/***************************************************************************/

#include <ft2build.h>

  FT_EXPORT_DEF( FT_Error )
  FT_Set_CSM_Adjustments( FT_Face  face,
                          FT_Fixed  sharpness_offset,
                          FT_Fixed  sharpness_slope,
                          FT_Fixed  thickness_offset,
                          FT_Fixed  thickness_slope )
  {
    FT_Error error = FT_Err_Invalid_Argument;
    itypeInterface iface;

    if ( !face )
      return FT_Err_Invalid_Face_Handle;

    iface = (itypeInterface)FT_Get_Module_Interface( FT_FACE_LIBRARY( face ),
                                                     "itype drv" );

    if (iface == NULL)
        return FT_Err_Cannot_Open_Resource;

    error = iface->set_csm_adjustments( face, sharpness_offset, sharpness_slope,
                                       thickness_offset, thickness_slope );

    return error;
  }


  FT_EXPORT_DEF( FT_Error )
  FT_Get_CSM_Adjustments( FT_Face  face,
                          FT_Fixed  *sharpness_offset,
                          FT_Fixed  *sharpness_slope,
                          FT_Fixed  *thickness_offset,
                          FT_Fixed  *thickness_slope )
  {
    FT_Error error = FT_Err_Invalid_Argument;
    itypeInterface iface;

    if ( !face )
      return FT_Err_Invalid_Face_Handle;

    if ( !sharpness_offset ||
         !sharpness_slope  ||
         !thickness_offset ||
         !thickness_slope )
        return FT_Err_Invalid_Argument;

    iface = (itypeInterface)FT_Get_Module_Interface( FT_FACE_LIBRARY( face ),
                                                     "itype drv" );
    if (iface == NULL)
        return FT_Err_Cannot_Open_Resource;

    error = iface->get_csm_adjustments( face, sharpness_offset, sharpness_slope,
                                       thickness_offset, thickness_slope );

    return error;
  }

  /* END */
